using System;
using System.Collections.Generic;
using System.Linq;

public class PericaChristmasTree
{
    public class Point
    {
        public int Id { get; set; }
        public double X { get; set; }
        public double Y { get; set; }
        public int NewId { get; set; } 
    }

    public class Edge
    {
        public int U { get; set; } 
        public int V { get; set; } 
        public double Weight { get; set; }
    }

    public class DSU
    {
        private int[] parent;
        public DSU(int size)
        {
            parent = new int[size];
            for (int i = 0; i < size; i++) parent[i] = i;
        }

        public int Find(int i)
        {
            if (parent[i] == i) return i;
            return parent[i] = Find(parent[i]);
        }

        public bool Union(int i, int j)
        {
            int root_i = Find(i);
            int root_j = Find(j);
            if (root_i != root_j)
            {
                parent[root_i] = root_j;
                return true;
            }
            return false;
        }
    }

    public static double ManhattanDistance(Point p1, Point p2)
    {
        return Math.Abs(p1.X - p2.X) + Math.Abs(p1.Y - p2.Y);
    }

    public static void Solve()
    {
        string[] line1 = Console.ReadLine().Split(' ');
        int N = int.Parse(line1[0]);
        double Epsilon = double.Parse(line1[1], System.Globalization.CultureInfo.InvariantCulture);

        List<Point> P = new List<Point>();
        for (int i = 0; i < N; i++)
        {
            string[] coords = Console.ReadLine().Split(' ');
            P.Add(new Point
            {
                Id = i + 1,
                X = double.Parse(coords[0], System.Globalization.CultureInfo.InvariantCulture),
                Y = double.Parse(coords[1], System.Globalization.CultureInfo.InvariantCulture)
            });
        }

        double s = Epsilon / 3.0;
        
        Dictionary<string, Point> representativePoints = new Dictionary<string, Point>();

        foreach (var p in P)
        {
            int ix = (int)Math.Floor(p.X / s);
            int iy = (int)Math.Floor(p.Y / s);
            string key = $"{ix},{iy}";

            if (!representativePoints.ContainsKey(key))
            {
                representativePoints.Add(key, p);
            }
        }

        List<Point> Q = representativePoints.Values.ToList();
        int Q_size = Q.Count;

        for (int i = 0; i < Q_size; i++)
        {
            Q[i].NewId = i;
        }

        List<Edge> edges = new List<Edge>();
        for (int i = 0; i < Q_size; i++)
        {
            for (int j = i + 1; j < Q_size; j++)
            {
                edges.Add(new Edge
                {
                    U = Q[i].NewId,
                    V = Q[j].NewId,
                    Weight = ManhattanDistance(Q[i], Q[j])
                });
            }
        }

        edges.Sort((a, b) => a.Weight.CompareTo(b.Weight));

        DSU dsu = new DSU(Q_size);
        List<Edge> T_edges = new List<Edge>();
        
        foreach (var edge in edges)
        {
            if (dsu.Union(edge.U, edge.V))
            {
                T_edges.Add(edge);
                if (T_edges.Count == Q_size - 1)
                {
                    break;
                }
            }
        }
        
        Console.WriteLine(Q_size);

        Console.WriteLine(string.Join(" ", Q.Select(p => p.Id)));

        foreach (var edge in T_edges)
        {
            int u_id = Q.First(p => p.NewId == edge.U).Id;
            int v_id = Q.First(p => p.NewId == edge.V).Id;
            Console.WriteLine($"{u_id} {v_id}");
        }
    }

    public static void Main(string[] args)
    {
        System.Threading.Thread.CurrentThread.CurrentCulture = System.Globalization.CultureInfo.InvariantCulture;
        Solve();
    }
}